//////////////////////////Securitas by Rene Pol aka Realspawn -rp-interactive.nl   09-03-2016////////////////////



#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"
#define PRAGMA_PATH "Scripts"
#define PRAGMA_PATH "Sounds"

var soundtrack_handle;

SOUND* bounce_snd = "bounce.wav";
SOUND* deathc_snd = "deathc.wav";

action securitas_name();
action securitas_ball();
action convict_spawner();
action horizontal_guard();
action vertical_guard();

BMAP* gameover_map = "gameover.png"; 

PANEL* gameover_pan =
{
	bmap = gameover_map; 
	pos_x = 0;
	pos_y = 0;
	

}

BMAP* start_map = "start.png"; 

PANEL* start_pan =
{
	bmap = start_map;
	pos_x = 0;
	pos_y = 0;
	

}




var balls_number =3; 

FONT*		fnt_pan = "IMPACT#18"; 
PANEL* pan_balls_number 	= {digits=120,2,"Balls :%00.0f",fnt_pan,1,balls_number; 
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=255; red=255;
}

var score_number =0; 

FONT*		fnt_pan = "IMPACT#18"; 
PANEL* pan_score_number 	= {digits=10,2,"Score :%00.0f",fnt_pan,1,score_number; 
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=255; red=255;
}

var prisoner_number =0;

FONT*		fnt_pan = "IMPACT#18"; 
PANEL* pan_prisoner_number 	= {digits=220,2,"Escaped :%00.0f",fnt_pan,1,prisoner_number; 
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=255; red=255;// the color of the font that is used. This is yellow.
}

var best_guard =0; 

FONT*		fnt_pan = "IMPACT#18"; 
PANEL* pan_best_guard 	= {digits=460,2,"Best guard score :%00.0f",fnt_pan,1,best_guard; 
	layer = 20; //the layer of the panel
	flags = SHOW;green=255; blue=255; red=255;
}


#define HIGH_SCORE_SAVE_FILE "hs.score"

TEXT* input_file = { strings = 1; } 

void load_highscore()
{
	txt_load(input_file, HIGH_SCORE_SAVE_FILE);
	wait(1); 
	
	best_guard = str_to_float( (input_file.pstring)[0] ); 
}

void save_highscore()
{
	var file_handle = file_open_write(HIGH_SCORE_SAVE_FILE);
	wait(1); 
	
	file_str_write(file_handle, str_for_float(NULL, (double)best_guard)); 
	file_close(file_handle);
}



var name_securitas =0;
var enable_game = 0;

function game_over()
{
	if(balls_number ==0){
		score_number = score_number - prisoner_number*5;
		if(score_number > best_guard){
			best_guard = score_number;
			save_highscore();
		}
		set(gameover_pan,SHOW);
		name_securitas =0;
		enable_game = 0;
		wait(1);
		ent_create("securitas.mdl", vector(-2,182,113), securitas_name);
		ent_create("secball.mdl", vector(61,245,127), securitas_ball);
		ent_create("convict.mdl", vector(-721,178,141), convict_spawner);

	}
}


function begin_game()
{
	if(enable_game ==0){
		reset(start_pan,SHOW);
		reset(gameover_pan,SHOW);
		balls_number = 3;
		prisoner_number = 0;
		score_number = 0;
		name_securitas =1;
		enable_game = 1;
		ent_create("guard.mdl", vector(-165,-754,124), horizontal_guard);
		ent_create("guard2.mdl", vector(770,148,124), vertical_guard);
	}
}


function main()
{
	video_set(600,600,32,0);
	shadow_stencil = 2; 
	soundtrack_handle = media_loop("ingame.wav", NULL, 100);
	level_load("Securitas.WMB");
	load_highscore();
	name_securitas =0;
	set(start_pan,SHOW);
	on_space = begin_game;
}


function ball_collides()
{

			snd_play(bounce_snd,100,0);

	vec_to_angle(my.pan,bounce);

	my.pan += 10 - random(20);
	my.tilt = 0;
	wait(1);
}


action bouncing_ball()
{
	var speed = 25;
	set(my,METAL | BRIGHT | TRANSLUCENT);
	my.alpha =60;
	my.pan += 10 - random(20);	
	my.emask |= (ENABLE_BLOCK | ENABLE_ENTITY); 
	my.event = ball_collides;
	my.skill1 = 999;
	while(1)
	{
		
		c_move(my, vector(speed * time_step, 0, 0),nullvector, NULL); 

		wait(1);
		
		if(score_number >300){
			speed = 27;
		}
		if(score_number >500){
			speed = 29;
		}
		if(score_number >1000){
			speed = 31;
		}
		if(score_number >1500){
			speed = 33;
		}
		if(my.x >=820){
			set(my,INVISIBLE | PASSABLE);
			balls_number -=1;
			ent_remove(me);
			game_over();
			break;
		}
		if(my.y <=-820){
			set(my,INVISIBLE | PASSABLE);
			balls_number -=1;
			wait(1);
			ent_remove(me);
			
			game_over();
			break;
		}
	}
}



action securitas_name()
{
	my.pan = -90;
	set(my, BRIGHT | METAL | TRANSLUCENT  | PASSABLE);
	my.alpha = 100;
	while(1)
	{

		if(name_securitas ==1)
		
		
		my.alpha -=5*time_step;
		wait(1);
		if(my.alpha <=0){
			
			ent_remove(me);
			name_securitas = 0;
			
			break;
		}

	}
}

action securitas_ball()
{
	set(my, BRIGHT | METAL | TRANSLUCENT | PASSABLE);
	my.alpha = 100;

	while(1)
	{

		if(name_securitas ==1)

		
		my.alpha -=5*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_create("secball.mdl", vector(my.x,my.y,my.z), bouncing_ball);
			wait(-0.5);
			ent_create("secball.mdl", vector(my.x,my.y,my.z), bouncing_ball);
			wait(-0.5);
			ent_create("secball.mdl", vector(my.x,my.y,my.z), bouncing_ball);
			wait(1);
			ent_remove(me);
			name_securitas = 0;
			break;
		}

	}
}



action horizontal_guard()
{
	my.pan =-90;
	set(my,METAL | SHADOW | POLYGON);
	c_setminmax(me);  
	my.skill1 = 999;
	while(1)
	{

		c_move(my, vector(0, 100 * (key_x - key_z) * time_step, 0), nullvector, NULL |IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
		if(balls_number ==0){
			ent_remove(me);
			break;
		}
	}
}

action vertical_guard()
{
	my.pan = 90;
	set(my,METAL | SHADOW | POLYGON);
	c_setminmax(me);  
	my.skill1 = 999;
	while(1)
	{

		c_move(my, vector(100 * (key_cuu - key_cud) * time_step,0, 0), nullvector, NULL |IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
		if(balls_number ==0){
			ent_remove(me);
			break;
		}
	}
}


action throw_back()
{
		snd_play(deathc_snd,100,0);
	
	set(my,SHADOW| METAL | PASSABLE);
	while(1)
	{
		my.pan+=20*time_step;
		my.z +=25*time_step;
		my.x -=20*time_step;
		my.tilt+=20*time_step;
		my.roll+=20*time_step;
		wait(1);
		if(my.x <= -800){
			ent_remove(me);
			break;
		}
		
	}
}



function backin_jail()

{
	vec_to_angle(my.pan,bounce);

	my.pan += 10 - random(20);
	my.tilt = 0;
	wait(1);
	if (you) 
	{
		if (you.skill1 == 999) 
		{
			set(my,INVISIBLE | PASSABLE);
			my.event = NULL;
			ent_create("convict.mdl", vector(my.x,my.y,my.z+5), throw_back);
			wait(1);
			ent_remove(me); 
			score_number +=100;
			return;
		}
	}
}
action walking_convict()
{
	wait(1);
	var speed2 = 5;
	var run_percentage = 0;
	my.pan += 40 - random(80);	
	set(my,METAL | SHADOW | POLYGON);
	c_setminmax(me);  
	my.emask |= (ENABLE_BLOCK | ENABLE_ENTITY); 
	my.event = backin_jail;

	while(1)
	{
		if(enable_game ==0){
			ent_remove(me);
			break;
		}
		run_percentage %= 100;
		run_percentage += 5 * time_step;
		ent_animate(my, "run", run_percentage, ANM_CYCLE);
		
		c_move(my, vector(speed2 * time_step, 0, 0),nullvector, NULL | IGNORE_PASSABLE | IGNORE_SPRITES); 

		wait(1);
		if(score_number >300){
			speed2 = 7;
		}
		if(score_number >500){
			speed2 = 9;
		}
		if(score_number >1000){
			speed2 = 9;
		}
		if(score_number >1500){
			speed2 = 11;
		}
		if(my.x >=820){
			set(my,INVISIBLE | PASSABLE);
			prisoner_number +=1;
			ent_remove(me);
			break;
		}
		if(my.y <=-820){
			set(my,INVISIBLE | PASSABLE);
			prisoner_number +=1;
			ent_remove(me);
			break;
		}
		if(balls_number ==0){
			ent_remove(me);
			
			break;
			
		}
	}
}

var convicts;

action convict_spawner()

{
	set(my,PASSABLE | INVISIBLE);
	while(1)

	{


		
		
		wait(-5);
		ent_create("convict.mdl", vector(my.x+10,my.y,my.z), walking_convict);
		convicts -=1;
		wait(1);	
		
		if(balls_number ==0){
			ent_remove(me);
			break;
		}

		
	}	
}

